package io.burkard.cdk.services.codepipeline

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GitHubSourceAction {

  def apply(
    oauthToken: software.amazon.awscdk.SecretValue,
    owner: String,
    repo: String,
    output: software.amazon.awscdk.services.codepipeline.Artifact,
    branch: Option[String] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    trigger: Option[software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger] = None
  ): software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction =
    software.amazon.awscdk.services.codepipeline.actions.GitHubSourceAction.Builder
      .create()
      .oauthToken(oauthToken)
      .owner(owner)
      .repo(repo)
      .output(output)
      .branch(branch.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .trigger(trigger.orNull)
      .build()
}
