package io.burkard.cdk.services.codepipeline

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object JenkinsProviderAttributes {

  def apply(
    providerName: String,
    serverUrl: String,
    version: Option[String] = None
  ): software.amazon.awscdk.services.codepipeline.actions.JenkinsProviderAttributes =
    (new software.amazon.awscdk.services.codepipeline.actions.JenkinsProviderAttributes.Builder)
      .providerName(providerName)
      .serverUrl(serverUrl)
      .version(version.orNull)
      .build()
}
