package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfig {

  def apply(
    internalResourceId: String,
    computePlatform: Option[String] = None,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None,
    deploymentConfigName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig =
    software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.Builder
      .create(stackCtx, internalResourceId)
      .computePlatform(computePlatform.orNull)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .build()
}
