package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RevisionLocationProperty {

  def apply(
    s3Location: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty] = None,
    gitHubLocation: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty] = None,
    revisionType: Option[String] = None
  ): software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty =
    (new software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty.Builder)
      .s3Location(s3Location.orNull)
      .gitHubLocation(gitHubLocation.orNull)
      .revisionType(revisionType.orNull)
      .build()
}
