package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfigProps {

  def apply(
    computePlatform: Option[String] = None,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None,
    deploymentConfigName: Option[String] = None
  ): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps =
    (new software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder)
      .computePlatform(computePlatform.orNull)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .build()
}
