package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudWatchLogsConfigProperty {

  def apply(
    status: String,
    groupName: Option[String] = None,
    streamName: Option[String] = None
  ): software.amazon.awscdk.services.codebuild.CfnProject.CloudWatchLogsConfigProperty =
    (new software.amazon.awscdk.services.codebuild.CfnProject.CloudWatchLogsConfigProperty.Builder)
      .status(status)
      .groupName(groupName.orNull)
      .streamName(streamName.orNull)
      .build()
}
