package io.burkard.cdk.services.codebuild

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnProjectProps {

  def apply(
    artifacts: software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty,
    source: software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty,
    serviceRole: String,
    environment: software.amazon.awscdk.services.codebuild.CfnProject.EnvironmentProperty,
    name: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    logsConfig: Option[software.amazon.awscdk.services.codebuild.CfnProject.LogsConfigProperty] = None,
    secondarySourceVersions: Option[List[_]] = None,
    vpcConfig: Option[software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty] = None,
    badgeEnabled: Option[Boolean] = None,
    cache: Option[software.amazon.awscdk.services.codebuild.CfnProject.ProjectCacheProperty] = None,
    buildBatchConfig: Option[software.amazon.awscdk.services.codebuild.CfnProject.ProjectBuildBatchConfigProperty] = None,
    triggers: Option[software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty] = None,
    concurrentBuildLimit: Option[Number] = None,
    resourceAccessRole: Option[String] = None,
    fileSystemLocations: Option[List[_]] = None,
    secondarySources: Option[List[_]] = None,
    secondaryArtifacts: Option[List[_]] = None,
    queuedTimeoutInMinutes: Option[Number] = None,
    sourceVersion: Option[String] = None,
    encryptionKey: Option[String] = None,
    timeoutInMinutes: Option[Number] = None,
    visibility: Option[String] = None
  ): software.amazon.awscdk.services.codebuild.CfnProjectProps =
    (new software.amazon.awscdk.services.codebuild.CfnProjectProps.Builder)
      .artifacts(artifacts)
      .source(source)
      .serviceRole(serviceRole)
      .environment(environment)
      .name(name.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .logsConfig(logsConfig.orNull)
      .secondarySourceVersions(secondarySourceVersions.map(_.asJava).orNull)
      .vpcConfig(vpcConfig.orNull)
      .badgeEnabled(badgeEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cache(cache.orNull)
      .buildBatchConfig(buildBatchConfig.orNull)
      .triggers(triggers.orNull)
      .concurrentBuildLimit(concurrentBuildLimit.orNull)
      .resourceAccessRole(resourceAccessRole.orNull)
      .fileSystemLocations(fileSystemLocations.map(_.asJava).orNull)
      .secondarySources(secondarySources.map(_.asJava).orNull)
      .secondaryArtifacts(secondaryArtifacts.map(_.asJava).orNull)
      .queuedTimeoutInMinutes(queuedTimeoutInMinutes.orNull)
      .sourceVersion(sourceVersion.orNull)
      .encryptionKey(encryptionKey.orNull)
      .timeoutInMinutes(timeoutInMinutes.orNull)
      .visibility(visibility.orNull)
      .build()
}
