package io.burkard.cdk.services.codebuild

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProjectTriggersProperty {

  def apply(
    buildType: Option[String] = None,
    filterGroups: Option[List[_]] = None,
    webhook: Option[Boolean] = None
  ): software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty =
    (new software.amazon.awscdk.services.codebuild.CfnProject.ProjectTriggersProperty.Builder)
      .buildType(buildType.orNull)
      .filterGroups(filterGroups.map(_.asJava).orNull)
      .webhook(webhook.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
