package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricProperty {

  def apply(
    dimensions: Option[List[_]] = None,
    metricName: Option[String] = None,
    namespace: Option[String] = None
  ): software.amazon.awscdk.services.cloudwatch.CfnAlarm.MetricProperty =
    (new software.amazon.awscdk.services.cloudwatch.CfnAlarm.MetricProperty.Builder)
      .dimensions(dimensions.map(_.asJava).orNull)
      .metricName(metricName.orNull)
      .namespace(namespace.orNull)
      .build()
}
