package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ConfigurationProperty {

  def apply(
    metricTimeZone: Option[String] = None,
    excludedTimeRanges: Option[List[_]] = None
  ): software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.ConfigurationProperty =
    (new software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.ConfigurationProperty.Builder)
      .metricTimeZone(metricTimeZone.orNull)
      .excludedTimeRanges(excludedTimeRanges.map(_.asJava).orNull)
      .build()
}
