package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricProperty {

  def apply(
    metricName: String,
    namespace: String,
    dimensions: Option[List[_]] = None
  ): software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricProperty =
    (new software.amazon.awscdk.services.cloudwatch.CfnAnomalyDetector.MetricProperty.Builder)
      .metricName(metricName)
      .namespace(namespace)
      .dimensions(dimensions.map(_.asJava).orNull)
      .build()
}
