package io.burkard.cdk.services.cloudwatch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object YAxisProps {

  def apply(
    min: Option[Number] = None,
    max: Option[Number] = None,
    label: Option[String] = None,
    showUnits: Option[Boolean] = None
  ): software.amazon.awscdk.services.cloudwatch.YAxisProps =
    (new software.amazon.awscdk.services.cloudwatch.YAxisProps.Builder)
      .min(min.orNull)
      .max(max.orNull)
      .label(label.orNull)
      .showUnits(showUnits.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
