package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GraphWidget {

  def apply(
    stacked: Option[Boolean] = None,
    legendPosition: Option[software.amazon.awscdk.services.cloudwatch.LegendPosition] = None,
    statistic: Option[String] = None,
    liveData: Option[Boolean] = None,
    rightAnnotations: Option[List[_ <: software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation]] = None,
    leftAnnotations: Option[List[_ <: software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation]] = None,
    left: Option[List[_ <: software.amazon.awscdk.services.cloudwatch.IMetric]] = None,
    height: Option[Number] = None,
    rightYAxis: Option[software.amazon.awscdk.services.cloudwatch.YAxisProps] = None,
    region: Option[String] = None,
    title: Option[String] = None,
    leftYAxis: Option[software.amazon.awscdk.services.cloudwatch.YAxisProps] = None,
    setPeriodToTimeRange: Option[Boolean] = None,
    width: Option[Number] = None,
    period: Option[software.amazon.awscdk.Duration] = None,
    right: Option[List[_ <: software.amazon.awscdk.services.cloudwatch.IMetric]] = None,
    view: Option[software.amazon.awscdk.services.cloudwatch.GraphWidgetView] = None
  ): software.amazon.awscdk.services.cloudwatch.GraphWidget =
    software.amazon.awscdk.services.cloudwatch.GraphWidget.Builder
      .create()
      .stacked(stacked.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .legendPosition(legendPosition.orNull)
      .statistic(statistic.orNull)
      .liveData(liveData.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .rightAnnotations(rightAnnotations.map(_.asJava).orNull)
      .leftAnnotations(leftAnnotations.map(_.asJava).orNull)
      .left(left.map(_.asJava).orNull)
      .height(height.orNull)
      .rightYAxis(rightYAxis.orNull)
      .region(region.orNull)
      .title(title.orNull)
      .leftYAxis(leftYAxis.orNull)
      .setPeriodToTimeRange(setPeriodToTimeRange.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .width(width.orNull)
      .period(period.orNull)
      .right(right.map(_.asJava).orNull)
      .view(view.orNull)
      .build()
}
