package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnInsightRuleProps {

  def apply(
    ruleBody: String,
    ruleName: String,
    ruleState: String,
    tags: Option[List[_]] = None
  ): software.amazon.awscdk.services.cloudwatch.CfnInsightRuleProps =
    (new software.amazon.awscdk.services.cloudwatch.CfnInsightRuleProps.Builder)
      .ruleBody(ruleBody)
      .ruleName(ruleName)
      .ruleState(ruleState)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
