package io.burkard.cdk.services.cloudtrail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventSelectorProperty {

  def apply(
    dataResources: Option[List[_]] = None,
    excludeManagementEventSources: Option[List[String]] = None,
    includeManagementEvents: Option[Boolean] = None,
    readWriteType: Option[String] = None
  ): software.amazon.awscdk.services.cloudtrail.CfnTrail.EventSelectorProperty =
    (new software.amazon.awscdk.services.cloudtrail.CfnTrail.EventSelectorProperty.Builder)
      .dataResources(dataResources.map(_.asJava).orNull)
      .excludeManagementEventSources(excludeManagementEventSources.map(_.asJava).orNull)
      .includeManagementEvents(includeManagementEvents.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .readWriteType(readWriteType.orNull)
      .build()
}
