package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EdgeLambda {

  def apply(
    functionVersion: software.amazon.awscdk.services.lambda.IVersion,
    eventType: software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType,
    includeBody: Option[Boolean] = None
  ): software.amazon.awscdk.services.cloudfront.EdgeLambda =
    (new software.amazon.awscdk.services.cloudfront.EdgeLambda.Builder)
      .functionVersion(functionVersion)
      .eventType(eventType)
      .includeBody(includeBody.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
