package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CorsConfigProperty {

  def apply(
    originOverride: Boolean,
    accessControlAllowMethods: software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlAllowMethodsProperty,
    accessControlAllowOrigins: software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlAllowOriginsProperty,
    accessControlAllowHeaders: software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlAllowHeadersProperty,
    accessControlAllowCredentials: Boolean,
    accessControlExposeHeaders: Option[software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlExposeHeadersProperty] = None,
    accessControlMaxAgeSec: Option[Number] = None
  ): software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.CorsConfigProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.CorsConfigProperty.Builder)
      .originOverride(originOverride)
      .accessControlAllowMethods(accessControlAllowMethods)
      .accessControlAllowOrigins(accessControlAllowOrigins)
      .accessControlAllowHeaders(accessControlAllowHeaders)
      .accessControlAllowCredentials(accessControlAllowCredentials)
      .accessControlExposeHeaders(accessControlExposeHeaders.orNull)
      .accessControlMaxAgeSec(accessControlMaxAgeSec.orNull)
      .build()
}
