package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PublicKeyConfigProperty {

  def apply(
    name: String,
    callerReference: String,
    encodedKey: String,
    comment: Option[String] = None
  ): software.amazon.awscdk.services.cloudfront.CfnPublicKey.PublicKeyConfigProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnPublicKey.PublicKeyConfigProperty.Builder)
      .name(name)
      .callerReference(callerReference)
      .encodedKey(encodedKey)
      .comment(comment.orNull)
      .build()
}
