package io.burkard.cdk.services.cloudfront

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ForwardedValuesProperty {

  def apply(
    queryString: Boolean,
    queryStringCacheKeys: Option[List[String]] = None,
    cookies: Option[software.amazon.awscdk.services.cloudfront.CfnDistribution.CookiesProperty] = None,
    headers: Option[List[String]] = None
  ): software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty.Builder)
      .queryString(queryString)
      .queryStringCacheKeys(queryStringCacheKeys.map(_.asJava).orNull)
      .cookies(cookies.orNull)
      .headers(headers.map(_.asJava).orNull)
      .build()
}
