package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourceVersionProps {

  def apply(
    typeName: String,
    schemaHandlerPackage: String,
    loggingConfig: Option[software.amazon.awscdk.services.cloudformation.CfnResourceVersion.LoggingConfigProperty] = None,
    executionRoleArn: Option[String] = None
  ): software.amazon.awscdk.services.cloudformation.CfnResourceVersionProps =
    (new software.amazon.awscdk.services.cloudformation.CfnResourceVersionProps.Builder)
      .typeName(typeName)
      .schemaHandlerPackage(schemaHandlerPackage)
      .loggingConfig(loggingConfig.orNull)
      .executionRoleArn(executionRoleArn.orNull)
      .build()
}
