package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourceVersion {

  def apply(
    internalResourceId: String,
    typeName: String,
    schemaHandlerPackage: String,
    loggingConfig: Option[software.amazon.awscdk.services.cloudformation.CfnResourceVersion.LoggingConfigProperty] = None,
    executionRoleArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudformation.CfnResourceVersion =
    software.amazon.awscdk.services.cloudformation.CfnResourceVersion.Builder
      .create(stackCtx, internalResourceId)
      .typeName(typeName)
      .schemaHandlerPackage(schemaHandlerPackage)
      .loggingConfig(loggingConfig.orNull)
      .executionRoleArn(executionRoleArn.orNull)
      .build()
}
