package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnModuleDefaultVersion {

  def apply(
    internalResourceId: String,
    moduleName: Option[String] = None,
    versionId: Option[String] = None,
    arn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudformation.CfnModuleDefaultVersion =
    software.amazon.awscdk.services.cloudformation.CfnModuleDefaultVersion.Builder
      .create(stackCtx, internalResourceId)
      .moduleName(moduleName.orNull)
      .versionId(versionId.orNull)
      .arn(arn.orNull)
      .build()
}
