package io.burkard.cdk.cloudassembly

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileSource {

  def apply(
    executable: Option[List[String]] = None,
    path: Option[String] = None,
    packaging: Option[software.amazon.awscdk.cloudassembly.schema.FileAssetPackaging] = None
  ): software.amazon.awscdk.cloudassembly.schema.FileSource =
    (new software.amazon.awscdk.cloudassembly.schema.FileSource.Builder)
      .executable(executable.map(_.asJava).orNull)
      .path(path.orNull)
      .packaging(packaging.orNull)
      .build()
}
