package io.burkard.cdk.cloudassembly

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EndpointServiceAvailabilityZonesContextQuery {

  def apply(
    region: String,
    serviceName: String,
    account: String,
    lookupRoleArn: Option[String] = None
  ): software.amazon.awscdk.cloudassembly.schema.EndpointServiceAvailabilityZonesContextQuery =
    (new software.amazon.awscdk.cloudassembly.schema.EndpointServiceAvailabilityZonesContextQuery.Builder)
      .region(region)
      .serviceName(serviceName)
      .account(account)
      .lookupRoleArn(lookupRoleArn.orNull)
      .build()
}
