package io.burkard.cdk.cloudassembly

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AssemblyManifest {

  def apply(
    version: String,
    runtime: Option[software.amazon.awscdk.cloudassembly.schema.RuntimeInfo] = None,
    missing: Option[List[_ <: software.amazon.awscdk.cloudassembly.schema.MissingContext]] = None,
    artifacts: Option[Map[String, _ <: software.amazon.awscdk.cloudassembly.schema.ArtifactManifest]] = None
  ): software.amazon.awscdk.cloudassembly.schema.AssemblyManifest =
    (new software.amazon.awscdk.cloudassembly.schema.AssemblyManifest.Builder)
      .version(version)
      .runtime(runtime.orNull)
      .missing(missing.map(_.asJava).orNull)
      .artifacts(artifacts.map(_.asJava).orNull)
      .build()
}
