package io.burkard.cdk.services.cassandra

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnKeyspaceProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    keyspaceName: Option[String] = None
  ): software.amazon.awscdk.services.cassandra.CfnKeyspaceProps =
    (new software.amazon.awscdk.services.cassandra.CfnKeyspaceProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .keyspaceName(keyspaceName.orNull)
      .build()
}
