package io.burkard.cdk.services.budgets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NotificationProperty {

  def apply(
    threshold: Number,
    comparisonOperator: String,
    notificationType: String,
    thresholdType: Option[String] = None
  ): software.amazon.awscdk.services.budgets.CfnBudget.NotificationProperty =
    (new software.amazon.awscdk.services.budgets.CfnBudget.NotificationProperty.Builder)
      .threshold(threshold)
      .comparisonOperator(comparisonOperator)
      .notificationType(notificationType)
      .thresholdType(thresholdType.orNull)
      .build()
}
