package io.burkard.cdk.services.batch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogConfigurationProperty {

  def apply(
    logDriver: String,
    options: Option[AnyRef] = None,
    secretOptions: Option[List[_]] = None
  ): software.amazon.awscdk.services.batch.CfnJobDefinition.LogConfigurationProperty =
    (new software.amazon.awscdk.services.batch.CfnJobDefinition.LogConfigurationProperty.Builder)
      .logDriver(logDriver)
      .options(options.orNull)
      .secretOptions(secretOptions.map(_.asJava).orNull)
      .build()
}
