package io.burkard.cdk.services.batch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EvaluateOnExitProperty {

  def apply(
    action: String,
    onExitCode: Option[String] = None,
    onReason: Option[String] = None,
    onStatusReason: Option[String] = None
  ): software.amazon.awscdk.services.batch.CfnJobDefinition.EvaluateOnExitProperty =
    (new software.amazon.awscdk.services.batch.CfnJobDefinition.EvaluateOnExitProperty.Builder)
      .action(action)
      .onExitCode(onExitCode.orNull)
      .onReason(onReason.orNull)
      .onStatusReason(onStatusReason.orNull)
      .build()
}
