package io.burkard.cdk.services.autoscalingplans

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnScalingPlanProps {

  def apply(
    applicationSource: software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty,
    scalingInstructions: List[_]
  ): software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps =
    (new software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps.Builder)
      .applicationSource(applicationSource)
      .scalingInstructions(scalingInstructions.asJava)
      .build()
}
