package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScalingInterval {

  def apply(
    change: Number,
    upper: Option[Number] = None,
    lower: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.common.ScalingInterval =
    (new software.amazon.awscdk.services.autoscaling.common.ScalingInterval.Builder)
      .change(change)
      .upper(upper.orNull)
      .lower(lower.orNull)
      .build()
}
