package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceSnapshotOptions {

  def apply(
    deleteOnTermination: Option[Boolean] = None,
    iops: Option[Number] = None,
    volumeSize: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.autoscaling.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.autoscaling.EbsDeviceSnapshotOptions =
    (new software.amazon.awscdk.services.autoscaling.EbsDeviceSnapshotOptions.Builder)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .iops(iops.orNull)
      .volumeSize(volumeSize.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
