package io.burkard.cdk.services.autoscaling

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApplyCloudFormationInitOptions {

  def apply(
    embedFingerprint: Option[Boolean] = None,
    ignoreFailures: Option[Boolean] = None,
    includeRole: Option[Boolean] = None,
    printLog: Option[Boolean] = None,
    includeUrl: Option[Boolean] = None,
    configSets: Option[List[String]] = None
  ): software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions =
    (new software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions.Builder)
      .embedFingerprint(embedFingerprint.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .ignoreFailures(ignoreFailures.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .includeRole(includeRole.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .printLog(printLog.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .includeUrl(includeUrl.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .configSets(configSets.map(_.asJava).orNull)
      .build()
}
