package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LaunchTemplateSpecificationProperty {

  def apply(
    version: String,
    launchTemplateId: Option[String] = None,
    launchTemplateName: Option[String] = None
  ): software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.LaunchTemplateSpecificationProperty =
    (new software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.Builder)
      .version(version)
      .launchTemplateId(launchTemplateId.orNull)
      .launchTemplateName(launchTemplateName.orNull)
      .build()
}
