package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptionsBase {

  def apply(
    deleteOnTermination: Option[Boolean] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.autoscaling.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.autoscaling.EbsDeviceOptionsBase =
    (new software.amazon.awscdk.services.autoscaling.EbsDeviceOptionsBase.Builder)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
