package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CompleteScalingInterval {

  def apply(
    upper: Number,
    lower: Number,
    change: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.common.CompleteScalingInterval =
    (new software.amazon.awscdk.services.autoscaling.common.CompleteScalingInterval.Builder)
      .upper(upper)
      .lower(lower)
      .change(change.orNull)
      .build()
}
