package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestCountScalingProps {

  def apply(
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None,
    disableScaleIn: Option[Boolean] = None,
    targetRequestsPerMinute: Option[Number] = None,
    cooldown: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.autoscaling.RequestCountScalingProps =
    (new software.amazon.awscdk.services.autoscaling.RequestCountScalingProps.Builder)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .targetRequestsPerMinute(targetRequestsPerMinute.orNull)
      .cooldown(cooldown.orNull)
      .build()
}
