package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BaseTargetTrackingProps {

  def apply(
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None,
    disableScaleIn: Option[Boolean] = None,
    cooldown: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.autoscaling.BaseTargetTrackingProps =
    (new software.amazon.awscdk.services.autoscaling.BaseTargetTrackingProps.Builder)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cooldown(cooldown.orNull)
      .build()
}
