package io.burkard.cdk.services.athena

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResultConfigurationUpdatesProperty {

  def apply(
    encryptionConfiguration: Option[software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty] = None,
    removeEncryptionConfiguration: Option[Boolean] = None,
    removeOutputLocation: Option[Boolean] = None,
    outputLocation: Option[String] = None
  ): software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationUpdatesProperty =
    (new software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationUpdatesProperty.Builder)
      .encryptionConfiguration(encryptionConfiguration.orNull)
      .removeEncryptionConfiguration(removeEncryptionConfiguration.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .removeOutputLocation(removeOutputLocation.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .outputLocation(outputLocation.orNull)
      .build()
}
