package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AdditionalAuthenticationProviderProperty {

  def apply(
    authenticationType: String,
    lambdaAuthorizerConfig: Option[software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty] = None,
    openIdConnectConfig: Option[software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty] = None,
    userPoolConfig: Option[software.amazon.awscdk.services.appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty] = None
  ): software.amazon.awscdk.services.appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty =
    (new software.amazon.awscdk.services.appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty.Builder)
      .authenticationType(authenticationType)
      .lambdaAuthorizerConfig(lambdaAuthorizerConfig.orNull)
      .openIdConnectConfig(openIdConnectConfig.orNull)
      .userPoolConfig(userPoolConfig.orNull)
      .build()
}
