package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGraphQLSchema {

  def apply(
    internalResourceId: String,
    apiId: String,
    definition: Option[String] = None,
    definitionS3Location: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appsync.CfnGraphQLSchema =
    software.amazon.awscdk.services.appsync.CfnGraphQLSchema.Builder
      .create(stackCtx, internalResourceId)
      .apiId(apiId)
      .definition(definition.orNull)
      .definitionS3Location(definitionS3Location.orNull)
      .build()
}
