package io.burkard.cdk.services.appsync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CachingConfigProperty {

  def apply(
    ttl: Option[Number] = None,
    cachingKeys: Option[List[String]] = None
  ): software.amazon.awscdk.services.appsync.CfnResolver.CachingConfigProperty =
    (new software.amazon.awscdk.services.appsync.CfnResolver.CachingConfigProperty.Builder)
      .ttl(ttl.orNull)
      .cachingKeys(cachingKeys.map(_.asJava).orNull)
      .build()
}
