package io.burkard.cdk.services.appstream

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StorageConnectorProperty {

  def apply(
    connectorType: String,
    resourceIdentifier: Option[String] = None,
    domains: Option[List[String]] = None
  ): software.amazon.awscdk.services.appstream.CfnStack.StorageConnectorProperty =
    (new software.amazon.awscdk.services.appstream.CfnStack.StorageConnectorProperty.Builder)
      .connectorType(connectorType)
      .resourceIdentifier(resourceIdentifier.orNull)
      .domains(domains.map(_.asJava).orNull)
      .build()
}
