package io.burkard.cdk.services.appstream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScriptDetailsProperty {

  def apply(
    executablePath: String,
    scriptS3Location: software.amazon.awscdk.services.appstream.CfnAppBlock.S3LocationProperty,
    timeoutInSeconds: Number,
    executableParameters: Option[String] = None
  ): software.amazon.awscdk.services.appstream.CfnAppBlock.ScriptDetailsProperty =
    (new software.amazon.awscdk.services.appstream.CfnAppBlock.ScriptDetailsProperty.Builder)
      .executablePath(executablePath)
      .scriptS3Location(scriptS3Location)
      .timeoutInSeconds(timeoutInSeconds)
      .executableParameters(executableParameters.orNull)
      .build()
}
