package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OutlierDetectionProperty {

  def apply(
    interval: software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty,
    baseEjectionDuration: software.amazon.awscdk.services.appmesh.CfnVirtualNode.DurationProperty,
    maxEjectionPercent: Number,
    maxServerErrors: Number
  ): software.amazon.awscdk.services.appmesh.CfnVirtualNode.OutlierDetectionProperty =
    (new software.amazon.awscdk.services.appmesh.CfnVirtualNode.OutlierDetectionProperty.Builder)
      .interval(interval)
      .baseEjectionDuration(baseEjectionDuration)
      .maxEjectionPercent(maxEjectionPercent)
      .maxServerErrors(maxServerErrors)
      .build()
}
