package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Http2GatewayListenerOptions {

  def apply(
    port: Option[Number] = None,
    healthCheck: Option[software.amazon.awscdk.services.appmesh.HealthCheck] = None,
    connectionPool: Option[software.amazon.awscdk.services.appmesh.Http2ConnectionPool] = None,
    tls: Option[software.amazon.awscdk.services.appmesh.ListenerTlsOptions] = None
  ): software.amazon.awscdk.services.appmesh.Http2GatewayListenerOptions =
    (new software.amazon.awscdk.services.appmesh.Http2GatewayListenerOptions.Builder)
      .port(port.orNull)
      .healthCheck(healthCheck.orNull)
      .connectionPool(connectionPool.orNull)
      .tls(tls.orNull)
      .build()
}
