package io.burkard.cdk.services.applicationinsights

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WindowsEventProperty {

  def apply(
    eventLevels: List[String],
    eventName: String,
    logGroupName: String,
    patternSet: Option[String] = None
  ): software.amazon.awscdk.services.applicationinsights.CfnApplication.WindowsEventProperty =
    (new software.amazon.awscdk.services.applicationinsights.CfnApplication.WindowsEventProperty.Builder)
      .eventLevels(eventLevels.asJava)
      .eventName(eventName)
      .logGroupName(logGroupName)
      .patternSet(patternSet.orNull)
      .build()
}
