package io.burkard.cdk.services.applicationinsights

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ComponentConfigurationProperty {

  def apply(
    configurationDetails: Option[software.amazon.awscdk.services.applicationinsights.CfnApplication.ConfigurationDetailsProperty] = None,
    subComponentTypeConfigurations: Option[List[_]] = None
  ): software.amazon.awscdk.services.applicationinsights.CfnApplication.ComponentConfigurationProperty =
    (new software.amazon.awscdk.services.applicationinsights.CfnApplication.ComponentConfigurationProperty.Builder)
      .configurationDetails(configurationDetails.orNull)
      .subComponentTypeConfigurations(subComponentTypeConfigurations.map(_.asJava).orNull)
      .build()
}
