package io.burkard.cdk.services.appflow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ErrorHandlingConfigProperty {

  def apply(
    bucketName: Option[String] = None,
    failOnFirstError: Option[Boolean] = None,
    bucketPrefix: Option[String] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty.Builder)
      .bucketName(bucketName.orNull)
      .failOnFirstError(failOnFirstError.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .bucketPrefix(bucketPrefix.orNull)
      .build()
}
