package io.burkard.cdk.services.appflow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DestinationFlowConfigProperty {

  def apply(
    destinationConnectorProperties: software.amazon.awscdk.services.appflow.CfnFlow.DestinationConnectorPropertiesProperty,
    connectorType: String,
    connectorProfileName: Option[String] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.DestinationFlowConfigProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.DestinationFlowConfigProperty.Builder)
      .destinationConnectorProperties(destinationConnectorProperties)
      .connectorType(connectorType)
      .connectorProfileName(connectorProfileName.orNull)
      .build()
}
